/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

public class DocumentInfo {
    public static final String ENCODING_ISO = "ISO-8859-1";
    public static final String ENCODING_UTF8 = "UTF8";
    public static int TYPE_HTML = 0;
    public static int TYPE_IMAGE = 1;
    public static int TYPE_CSS = 2;
    private String pageURL;
    private String baseURL;
    private String hostURL;
    private String protocol;
    private String params;
    private boolean postRequest;
    private String encoding = "ISO-8859-1";
    private int expectedContentType = TYPE_HTML;

    DocumentInfo(String url) {
        this.setUrl(url);
    }

    DocumentInfo(String url, int type) {
        this.setUrl(url);
        this.expectedContentType = type;
    }

    DocumentInfo(String url, String params, boolean postRequest) {
        this.params = params;
        this.postRequest = postRequest;
        this.setUrl(url);
    }

    public String getUrl() {
        return this.pageURL;
    }

    public String getFullUrl() {
        if (this.postRequest || this.params == null || this.params.equals("")) {
            return this.pageURL;
        }
        return this.pageURL + "?" + this.params;
    }

    public void setUrl(String url) {
        this.pageURL = this.convertURL(url);
        int index = this.pageURL.lastIndexOf(47);
        if (index == -1) {
            this.setBaseURL("");
            this.hostURL = "";
            this.protocol = "";
        } else {
            this.setBaseURL(this.pageURL.substring(0, index + 1));
            index = this.pageURL.indexOf("://");
            if (index != -1) {
                this.protocol = this.pageURL.substring(0, index + 1);
            }
            if ((index = this.pageURL.indexOf(47, index + 3)) != -1) {
                this.hostURL = this.pageURL.substring(0, index);
            } else {
                this.hostURL = this.pageURL;
                if (!this.protocol.startsWith("file")) {
                    this.setBaseURL(this.pageURL + "/");
                }
            }
        }
    }

    public int getExpectedContentType() {
        return this.expectedContentType;
    }

    public void setExpectedContentType(int requestType) {
        this.expectedContentType = requestType;
    }

    public boolean isPostRequest() {
        return this.postRequest;
    }

    public void setPostRequest(boolean postRequest) {
        this.postRequest = postRequest;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    static boolean isAbsoluteURL(String url) {
        return url.substring(0, Math.min(10, url.length())).indexOf("://") != -1;
    }

    String convertURL(String url) {
        if (url == null) {
            return this.pageURL;
        }
        if (DocumentInfo.isAbsoluteURL(url)) {
            return url;
        }
        if (url.startsWith("//")) {
            return this.protocol + url;
        }
        if (url.startsWith("/")) {
            return this.hostURL + url;
        }
        if (url.startsWith(".")) {
            int back = 0;
            while (url.length() > 0 && url.charAt(0) == '.') {
                if (url.startsWith("./")) {
                    url = url.substring(2);
                    continue;
                }
                if (url.startsWith("../")) {
                    url = url.substring(3);
                    ++back;
                    continue;
                }
                if (url.equals("..")) {
                    url = "";
                    ++back;
                    continue;
                }
                url = "";
            }
            String folder = this.getBaseURL().substring(this.hostURL.length() + 1);
            while (back > 0 && folder.length() > 0) {
                --back;
                int index = (folder = folder.substring(0, folder.length() - 1)).lastIndexOf(47);
                if (index == -1) {
                    folder = "";
                    continue;
                }
                folder = folder.substring(0, index + 1);
            }
            return this.hostURL + "/" + folder + url;
        }
        return this.getBaseURL() + url;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }
}

